#sd card file created modified stamp
#2022-08-20
#Paul Mirel

import os
import time
import rtc
import sdcardio
import storage
import board
import busio
import digitalio
import terminalio
import adafruit_pcf8523

myI2C = busio.I2C(board.SCL, board.SDA)
pcf_rtc = adafruit_pcf8523.PCF8523(myI2C)   # create the real time clock hardware object from the PCF8523 clock module
system_clock = rtc.RTC()
system_clock.datetime = pcf_rtc.datetime

hardware_clock_timenow = pcf_rtc.datetime
print("hardware_clock_timenow == {:}".format(hardware_clock_timenow))
feather_local_time = time.localtime()
print("feather_local_time == {:}".format(feather_local_time))      # microcontroller local time

# Adalogger Featherwing uses pin D10 for the SDCard chip select line on the SPI bus
# THAT WAS A COLLISION, so I modified the SD card to use pin D11 for chip select
sd_cs = board.D11
spi_bus = board.SPI()
# Connect to the card and mount the filesystem.
sdcard = sdcardio.SDCard( spi_bus, sd_cs )
vfs = storage.VfsFat( sdcard )
storage.mount( vfs, "/sd" )
# Files are under /sd
print()

with open( "/sd/test.txt", "w" ) as f:
    f.write( "year month day batch -- example string" )

with open("/sd/test.txt", "r") as f:
    print("Printing lines in file:")
    #print()
    line = f.readline()
    while line != '':
        print(line)
        line = f.readline()

created_time = os.stat("/sd/test.txt")
print(created_time)
print( "Program Completed" )
